<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CTopIntro extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function GetTopIntro($mod_id , $system = false , $widget = false) {
		global $_CONF , $_LANG_ID , $_TSM , $base;


		//device detection tablet
		if ($base->isTablet) {
				$cond = " AND find_in_set(2,item_device) ";
		} elseif ($base->isMobile) {
				//phone
				$cond = " AND find_in_set(3,item_device) ";
			} else {
				//desktop
				$cond = " AND find_in_set(1,item_device) ";
			}


		if ($system) {
			$intro = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:topintro']} as c, 
					{$this->tables['plugin:topintro_lang']} as l  
				WHERE 
					c.item_id=l.item_id AND 
					lang_id={$_LANG_ID} AND 
					item_status = 1 AND
					(find_in_set({$mod_id} , item_modules_global) OR item_default = 1 ) 
					{$cond}
				ORDER BY item_default ASC, rand() limit 1"
			);
		} else {
			
			$intro = $this->db->QFetchArray(
				"SELECT * FROM 
					{$this->tables['plugin:topintro']} as c, 
					{$this->tables['plugin:topintro_lang']} as l  
				WHERE 
					c.item_id=l.item_id AND 
					lang_id={$_LANG_ID} AND 
					(find_in_set({$mod_id} , item_modules) OR item_default= 1) AND 
					item_status=1 
					{$cond}
				ORDER BY item_default ASC, rand() limit 1"
			);
		}
		

		if (is_array($intro)) {

			$tpl = new CTemplateDynamic($this->tpl_path . "intro.htm");
			$intro["item_overlay"] = $this->plugins["skineditor"]->Overlay($intro["item_overlay"]);

			$intro["title"] = $intro["item_title"] ? $tpl->blockReplace("Title" , $intro) : "";
			$intro["text_1"] = $intro["item_text_1"] ? 
					$tpl->blockREplacE(
						"Text_1" , 
						array(
							"item_text_1"	=> nl2br($intro["item_text_1"])
						)
					): "";

			$intro["text_2"] = $intro["item_text_2"] ? 
					$tpl->blockREplacE(
						"Text_2" , 
						array(
							"item_text_2"	=> nl2br($intro["item_text_2"])
						)
					): "";


			if ($intro["item_show_menu"]) {
				$_TSM["BODY-EXTRA-ATTR"] .= " data-topintro-menu=\"true\" " ;
			} else {
				$_TSM["BODY-EXTRA-ATTR"] .= " data-topintro-menu=\"false\" " ;
			}
			
			if ($intro["item_content_type"]) {
				$intro["content"] = $tpl->blockReplace("Raw", $intro);
			} else {
				$intro["content"] = $tpl->blockReplace("Classic", $intro);
			}
			

			$buttons = 	$this->plugins["widgets"]->WidgetButtons(
				array( 
					"settings"	=> array(
						"lang_link_type"	=> $intro["item_link_type"],
						"lang_link_link"	=> $intro["item_link_link"],
						"lang_link_module"	=> $intro["item_link_module"],
						"lang_link_global"	=> $intro["item_link_global"],
						"lang_link_text"	=> $intro["item_link_text"],
						"lang_link_size"	=> $intro["item_link_size"],
						"lang_link_target"	=> $intro["item_link_target"],
						"lang_link_style"	=> $intro["item_link_style"],
						"lang_link_rel"		=> $intro["item_link_rel"],

						"lang_link2_type"	=> $intro["item_link2_type"],
						"lang_link2_link"	=> $intro["item_link2_link"],
						"lang_link2_module"	=> $intro["item_link2_module"],
						"lang_link2_global"	=> $intro["item_link2_global"],
						"lang_link2_text"	=> $intro["item_link2_text"],
						"lang_link2_size"	=> $intro["item_link2_size"],
						"lang_link2_target"	=> $intro["item_link2_target"],
						"lang_link2_style"	=> $intro["item_link2_style"],
						"lang_link2_rel"	=> $intro["item_link2_rel"],
					)
				), 
				$tpl
			);


			if ($intro["item_background"]) {
				
			}			

			return $tpl->blockReplace(
				"Main",
				$intro,
				$buttons,
				$this->plugins["backgrounds"]->GetBg($intro["item_background"]),
				$intro
			);
			
		}
		
	}
	



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onGlobalHooksExecute($module) {

		if ($module["mod_id"]) {
			$bg  = 	$this->GetTopIntro($module["mod_id"]);
		} elseif ($module["module_id"]) {
			$bg  = 	$this->GetTopIntro($module["module_id"] , true);
		}
		

		global $_TSM;

		$_TSM["PUB:TOPINTRO"] = $bg;

		return $bg;
	}


}

?>